/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiBuffer;
import cofh.thermalexpansion.gui.container.device.ContainerBuffer;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileBuffer
extends TileDeviceBase {
    int inputTracker;
    int outputTracker;
    public int quantityInput = 1;
    public int quantityOutput = 1;
    public boolean enableInput = true;
    public boolean enableOutput = true;

    public static void initialize() {
        int n = BlockDevice.Types.BUFFER.ordinal();
        TileDeviceBase.defaultSideConfig[n] = new TileTEBase.SideConfig();
        TileDeviceBase.defaultSideConfig[n].numConfig = 4;
        TileDeviceBase.defaultSideConfig[n].slotGroups = new int[][]{new int[0], {0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7, 8}};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSide = new boolean[]{false, true, false, true};
        TileDeviceBase.defaultSideConfig[n].allowExtractionSide = new boolean[]{false, false, true, true};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSlot = new boolean[]{true, true, true, true, true, true, true, true, true};
        TileDeviceBase.defaultSideConfig[n].allowExtractionSlot = new boolean[]{true, true, true, true, true, true, true, true, true};
        TileDeviceBase.defaultSideConfig[n].sideTex = new int[]{0, 1, 4, 7};
        TileDeviceBase.defaultSideConfig[n].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        GameRegistry.registerTileEntity(TileBuffer.class, (String)"thermalexpansion.Buffer");
    }

    public TileBuffer() {
        super(BlockDevice.Types.BUFFER);
        this.inventory = new ItemStack[9];
    }

    @Override
    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing] = 0;
        this.sideCache[this.facing ^ 1] = 2;
    }

    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (((TileEntity)this).field_145850_b.func_82737_E() % 16L == 0L && this.redstoneControlOrDisable()) {
            this.transferOutput();
            this.transferInput();
        }
    }

    protected void transferInput() {
        if (!this.enableInput || this.quantityInput <= 0) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 1) continue;
            for (int j = 0; j < this.inventory.length; ++j) {
                if (!this.extractItem(j, this.quantityInput, n)) continue;
                this.inputTracker = n;
                return;
            }
        }
    }

    protected void transferOutput() {
        if (!this.enableOutput || this.quantityOutput <= 0) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 2) continue;
            for (int j = this.inventory.length - 1; j >= 0; --j) {
                if (!this.transferItem(j, this.quantityOutput, n)) continue;
                this.outputTracker = n;
                return;
            }
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiBuffer(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerBuffer(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.inputTracker = nBTTagCompound.func_74762_e("TrackIn");
        this.outputTracker = nBTTagCompound.func_74762_e("TrackOut");
        this.quantityInput = MathHelper.clamp((int)nBTTagCompound.func_74762_e("Input"), (int)0, (int)64);
        this.quantityOutput = MathHelper.clamp((int)nBTTagCompound.func_74762_e("Output"), (int)0, (int)64);
        this.enableInput = nBTTagCompound.func_74767_n("EnableIn");
        this.enableOutput = nBTTagCompound.func_74767_n("EnableOut");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("TrackIn", this.inputTracker);
        nBTTagCompound.func_74768_a("TrackOut", this.outputTracker);
        nBTTagCompound.func_74768_a("Input", this.quantityInput);
        nBTTagCompound.func_74768_a("Output", this.quantityOutput);
        nBTTagCompound.func_74757_a("EnableIn", this.enableInput);
        nBTTagCompound.func_74757_a("EnableOut", this.enableOutput);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addInt(this.quantityInput);
        packetCoFHBase.addInt(this.quantityOutput);
        packetCoFHBase.addBool(this.enableInput);
        packetCoFHBase.addBool(this.enableOutput);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addInt(this.quantityInput);
        packetCoFHBase.addInt(this.quantityOutput);
        packetCoFHBase.addBool(this.enableInput);
        packetCoFHBase.addBool(this.enableOutput);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addInt(MathHelper.clamp((int)this.quantityInput, (int)0, (int)64));
        packetCoFHBase.addInt(MathHelper.clamp((int)this.quantityOutput, (int)0, (int)64));
        packetCoFHBase.addBool(this.enableInput);
        packetCoFHBase.addBool(this.enableOutput);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.quantityInput = packetCoFHBase.getInt();
        this.quantityOutput = packetCoFHBase.getInt();
        this.enableInput = packetCoFHBase.getBool();
        this.enableOutput = packetCoFHBase.getBool();
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.quantityInput = packetCoFHBase.getInt();
        this.quantityOutput = packetCoFHBase.getInt();
        this.enableInput = packetCoFHBase.getBool();
        this.enableOutput = packetCoFHBase.getBool();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.quantityInput = packetCoFHBase.getInt();
            this.quantityOutput = packetCoFHBase.getInt();
            this.enableInput = packetCoFHBase.getBool();
            this.enableOutput = packetCoFHBase.getBool();
        } else {
            packetCoFHBase.getInt();
            packetCoFHBase.getInt();
            packetCoFHBase.getBool();
            packetCoFHBase.getBool();
        }
    }

    @Override
    public boolean setFacing(int n) {
        if (n < 0 || n > 5) {
            return false;
        }
        this.facing = (byte)n;
        this.sideCache[this.facing] = 0;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }
}

